/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///#include <Dialog.h>
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#define  _DMSG(_str) //out_str(_str);

/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include "HelpID.h"
///	#include "Odlg8.h"
///	#include "ResizeDialog.h"
///	#include "MultiPaneDlg.h"
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include "TreeEditSplitter.h"

#include "GraphPageControl.h"


static bool redraw_button_handler(TreeNode& myTree, int nRow, int nCntrlType, Dialog& getNDlg)
{
   getNDlg.PostMessage(WM_USER_REDRAW_GRAPH);
   return true;
}
	
class GraphTreeEditSplitter : public TreeEditSplitter
{
public:
	GraphTreeEditSplitter() : TreeEditSplitter(true, true)
	{
		m_dwNoClicks = NOCLICK_DATA_PLOT | NOCLICK_LABEL | NOCLICK_TICKLABEL ;//| NOCLICK_LAYER ;
		m_nPlotIndex = -1;// to indicate no plot made yet
		m_dXFrom = -10;
		m_dXTo = 100;
	}
protected:
EVENTS_BEGIN
	ON_INIT(OnInitSplitter)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnCtrlResize)

	ON_GETNDLG_MSGS(GetTreeEditPaneID())
	
	ON_USER_MSG(WM_USER_REDRAW_GRAPH, OnRedraw)
	ON_USER_MSG(WM_USER_ON_TRACK, OnTrackSlider)
	
EVENTS_END
	BOOL OnRedraw(uint wParam, uint lParam)
	{
		plotSampleData(false);
		return TRUE;
	}
	BOOL OnTrackSlider(WPARAM wParam, LPARAM lParam)
	{
		int nPos = wParam;
		double* pVal = (double*) lParam;
		if(pVal)
		{
			int nEditRow = m_treeEditCntrl.GetEditRow();
			//printf("%d) Slider %d and %f\n", nEditRow, nPos, *pVal);
			TreeNode trEdit = m_treeEditCntrl.GetEditNode();
			trEdit.dVal = *pVal;
			plotSampleData(false);
		}
		else
			out_str("NULL lParam");
		
		return true;
	}
	
	BOOL OnInitSplitter()
	{
		CreateTreeEditPane();
		GraphControl gctrl;
		CreateMainPane(gctrl);
		if(gctrl)
		{
			m_graph.Create(gctrl, m_dwNoClicks);
		}
			
		plotSampleData();
		return SetReady();
	}
	//virtual
	void ConstructTree()
	{
		GETN_TREE(trTemp)
		GETN_CHECK(RealTime, "Real Time Update", 0)
		GETN_SLIDER(NumPts, "Num of Points", 20, "10|500|490")
		GETN_SLIDER(NumPeriods, "Num of Perids", 5, "1|11|10")
		GETN_SLIDER(Amplitude, "Amplitude", 10, "1|21|20")
		GETN_BUTTON(Update, "Redraw now", "")
		GETN_OPTION_EVENT(redraw_button_handler) //--- 4. row based event handler
		m_paramTree = trTemp;
	}
private:
	void plotSampleData(bool bNewGraph = true)
	{
		if(bNewGraph && m_nPlotIndex)
		{
			m_graph.RemovePlot(m_nPlotIndex);
			m_nPlotIndex = -1;
		}
		if(!bNewGraph && m_nPlotIndex < 0)
			bNewGraph = true;
		if(bNewGraph)
			m_graph.SetScale(m_dXFrom, m_dXTo);
			
		
		Dataset datX, datY;
		if(m_graph.GetData(datX, 0) && m_graph.GetData(datY, 1))
		{
			int nPts = m_paramTree.NumPts.nVal;
			double dAmplitude = m_paramTree.Amplitude.dVal;
			double dNumPeriods = m_paramTree.NumPeriods.dVal;

			//datX.Data(m_dXFrom, m_dXTo, (m_dXFrom - m_dXTo)/(nPts-1));
			datX.Data(m_dXFrom, m_dXTo, (m_dXTo - m_dXFrom)/(nPts-1));
			datY.SetSize(nPts);
			datY = sin(dNumPeriods * 2* PI * datX/(m_dXTo - m_dXFrom)) * dAmplitude;
			if(bNewGraph)
				m_nPlotIndex = m_graph.AddPlot(0, 1);
		}
		else
			m_nPlotIndex = -1;
	}
private:
	double				m_dXFrom;
	double				m_dXTo;
	GraphPageControl	m_graph;
	int					m_nPlotIndex;
	DWORD				m_dwNoClicks;
};
	
#define STR_DLG_NAME "GraphTreeEditDlg"

class GraphTreeEditDlg : public MultiPaneDlg
{
public:
	GraphTreeEditDlg() : MultiPaneDlg(IDD_PRESENTATION_MANAGER, "ODlg8") // use Presentation Manager resource,
	{
	}	
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		return DoModal(hWndParent);
	}
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_BN_CLICKED(IDC_PM_SHOW_PE, OnShowBottomPane)
EVENTS_END

//------------ Event Handlers ------------------------
	BOOL OnInitDialog()
	{
		waitCursor junk;
		//Profiler jj;
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Bottom Pane");
		vstrTipsUpDown[1] = _L("Hide Bottom Pane");
		MultiPaneDlg::OnInitDialog(IDC_PM_PRESENTATIONS, IDC_PM_SHOW_PE, IDC_PM_PE_PAGES, vstrTipsUpDown, STR_DLG_NAME);
		
		m_Top.Init(IDC_PM_PRESENTATIONS, *this, 0, STR_DLG_NAME);
		m_Bottom.Init(IDC_PM_PE_PAGES, *this, 1, STR_DLG_NAME);
		m_Top.Visible = true;
		SetInitReady();
		return true;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
			
		uint nButtonIDs[] = {IDOK, IDC_PM_NEW, IDC_PM_ADD, IDC_PM_REMOVE, 0};
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy);
		return TRUE;
	}
	
	//////////// local utilities/helper functions
private:
	ListTreeEditSplitter	m_Top;
	// for demo purpose, use same class for top and bottom pane, 
	// in real code, usually a diff class
	GraphTreeEditSplitter	m_Bottom;

};

bool GTest()
{
	GraphTreeEditDlg myDlg;
	
	int nRet = myDlg.DoModalEx(GetWindow());
	return true;
}

	